/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PED_ELTR_CALC]    Script Date: 07/11/2013 14:06:39 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PED_ELTR_CALC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PED_ELTR_CALC]
GO
GO
GO
GO

/*
	Calculo pedido eletronico

	EMPRESA: CORPORATE BUSINES
	DATA INICIO: 01/01/2004
	DATA TERMINO:01/01/2004 
	PROFISSIONAL:  Cristiano Nunes
*/
--SELECT * FROM UFD_EST_PED_ELTR_CALC(1,99,7, 0.60, 0.60, 0.60, 0,'1,2,3,4,5,6,7,8')
CREATE                         FUNCTION [dbo].[UFD_EST_PED_ELTR_CALC] (
--CREATE FUNCTION UFD_EST_PED_ELTR_CALC (
													@CD_EMP		INT,
													@CD_FIL_MTZ	INT,
													@CD_FIL_FAT	INT,
													@CURVA_A		MONEY,
													@CURVA_B		MONEY,
													@CURVA_C		MONEY,
													@CURVA_D		MONEY,
													@CURVA_AA		MONEY,
													@CD_SECOES	NVARCHAR(2500))
RETURNS @RS_TEMP TABLE (      CD_EMP         INT,
										CD_FIL_MTZ     INT,
										CD_FIL			INT,
										CD_PROD			INT,
										DS_PROD			NVARCHAR(100),
										DS_UN				NVARCHAR(5),
										DS_SIGLA       NVARCHAR(5),
										CD_SC				INT, 
										EST_PAD_ATU		MONEY, 
										QT_EST_MTZ		MONEY, 
										QT_EST_FILIAL  MONEY,
										QT_SOL			MONEY,	
										QT_MIN 			MONEY,
										VLR_FORN 		MONEY) 
AS
BEGIN
	DECLARE  @RS_EST_PED_ELTR_CALC TABLE  (
                                 CD_EMP         INT,
											CD_FIL_MTZ     INT,
											CD_FIL			INT,
											CD_PROD			INT,
											DS_PROD			NVARCHAR(100),
											DS_UN				NVARCHAR(5),
											DS_SIGLA       NVARCHAR(5),
											CD_SC				INT, 
											EST_PAD_ATU		MONEY, 
											QT_EST_MTZ		MONEY, 
											QT_EST_FILIAL  MONEY,
											QT_SOL			MONEY,	
											QT_MIN 			MONEY,
											VLR_FORN 		MONEY) 
	
	
	DECLARE  @RS_EST_MTZ TABLE  (
											CD_PROD        INT,
											QT_EST_ATU		MONEY
										 )
	
	INSERT @RS_EST_PED_ELTR_CALC
		SELECT
	         UFD_EST_PED_ELTR_IT_CALC.CD_EMP, 
			   @CD_FIL_MTZ AS CD_FIL_MTZ,
				UFD_EST_PED_ELTR_IT_CALC.CD_FILIAL, 
				UFD_EST_PED_ELTR_IT_CALC.CD_PROD, 
				UFD_EST_PED_ELTR_IT_CALC.DS_PROD, 
				UFD_EST_PED_ELTR_IT_CALC.DS_UN,
				UFD_EST_PED_ELTR_IT_CALC.DS_SIGLA,
				UFD_EST_PED_ELTR_IT_CALC.CD_SC, 
				UFD_EST_PED_ELTR_IT_CALC.EST_PAD_ATU, 		
				0 AS QT_EST_MTZ,
				QT_EST_FILIAL, 
				0 AS QT_SOL, 
				0 AS QT_MIN,
			   0 as VLR_FORN 
		FROM  
			UFD_EST_PED_ELTR_IT_CALC (@CD_EMP,@CD_FIL_FAT,@CD_SECOES)		

	INSERT @RS_EST_MTZ
		SELECT 
			PROD_QT_EST.CD_PROD, 
			(PROD_QT_EST.QT_EST_ATU + PROD_QT_EST.QT_PEND_ENT)
		FROM 
			DBO.UFD_BUSCA_QT_EST_TABLE(@CD_EMP, @CD_FIL_MTZ,  @CD_SECOES) PROD_QT_EST
		WHERE
			PROD_QT_EST.QT_EST_ATU  > 0

	--Zerar todos os estoque negativos
 	UPDATE @RS_EST_MTZ SET QT_EST_ATU  = 0 WHERE QT_EST_ATU < 0
	--Fim
	
INSERT @RS_TEMP
	SELECT 
      PED_ELTR.CD_EMP,
		PED_ELTR.CD_FIL_MTZ,
		PED_ELTR.CD_FIL,
		PED_ELTR.CD_PROD,
		PED_ELTR.DS_PROD,
		PED_ELTR.DS_UN,
		PED_ELTR.DS_SIGLA,
		PED_ELTR.CD_SC, 
		PED_ELTR.EST_PAD_ATU, 
		RS_EST.QT_EST_ATU AS QT_EST_MTZ, 
		PED_ELTR.QT_EST_FILIAL,
		PED_ELTR.QT_SOL,	
		PED_ELTR.QT_MIN,
		VLR_FORN = (SELECT DBO.UFD_EST_PROD_PRECO_TBL(@CD_EMP,@CD_FIL_FAT, PED_ELTR.CD_PROD,1))
	FROM
		@RS_EST_MTZ RS_EST, 
		@RS_EST_PED_ELTR_CALC PED_ELTR
	WHERE
		RS_EST.CD_PROD = PED_ELTR.CD_PROD
	
INSERT @RS_TEMP
	SELECT 
      PED_ELTR.CD_EMP,
		PED_ELTR.CD_FIL_MTZ,
		PED_ELTR.CD_FIL,
		PED_ELTR.CD_PROD,
		PED_ELTR.DS_PROD,
		PED_ELTR.DS_UN,
		PED_ELTR.DS_SIGLA,
		PED_ELTR.CD_SC, 
		PED_ELTR.EST_PAD_ATU, 
		0 AS QT_EST_MTZ, 
		PED_ELTR.QT_EST_FILIAL,
		PED_ELTR.QT_SOL,	
		PED_ELTR.QT_MIN,
		VLR_FORN = (SELECT DBO.UFD_EST_PROD_PRECO_TBL(@CD_EMP,@CD_FIL_FAT, PED_ELTR.CD_PROD,1))
	FROM
		@RS_EST_PED_ELTR_CALC PED_ELTR
	WHERE
		NOT EXISTS (SELECT CD_PROD 
  			    FROM 
					@RS_TEMP RS_TEMP
			    WHERE 
				 PED_ELTR.CD_PROD = RS_TEMP.CD_PROD)
	
	UPDATE @RS_TEMP SET QT_EST_FILIAL = 0 WHERE QT_EST_FILIAL < 0	
	
		BEGIN
			UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_A  WHERE DS_SIGLA = 'A'			
		END
	IF @CURVA_A > 1 
		BEGIN
			UPDATE @RS_TEMP SET EST_PAD_ATU = EST_PAD_ATU * @CURVA_A  WHERE DS_SIGLA = 'A'
		END

	IF @CURVA_B > 1 
		BEGIN
			UPDATE @RS_TEMP SET EST_PAD_ATU = EST_PAD_ATU * @CURVA_B  WHERE DS_SIGLA = 'B'
		END

	IF @CURVA_C > 1 
		BEGIN
			UPDATE @RS_TEMP SET EST_PAD_ATU = EST_PAD_ATU * @CURVA_C  WHERE DS_SIGLA = 'C'
		END

	IF @CURVA_D > 1 
		BEGIN
			UPDATE @RS_TEMP SET EST_PAD_ATU = EST_PAD_ATU * @CURVA_D  WHERE DS_SIGLA = 'D'
		END

	IF @CURVA_AA > 1 
		BEGIN
			UPDATE @RS_TEMP SET EST_PAD_ATU = EST_PAD_ATU * @CURVA_AA  WHERE DS_SIGLA = 'AA'
		END

	UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_A  WHERE DS_SIGLA = 'A'
	UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_B  WHERE DS_SIGLA = 'B'
	UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_C  WHERE DS_SIGLA = 'C'
	UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_D  WHERE DS_SIGLA = 'D'
	UPDATE @RS_TEMP SET QT_MIN = EST_PAD_ATU * @CURVA_AA  WHERE DS_SIGLA = 'AA'	
		
	UPDATE @RS_TEMP SET QT_SOL = (EST_PAD_ATU - QT_EST_FILIAL)
		WHERE                
			QT_MIN >= (QT_EST_FILIAL + QT_EST_MTZ)
	
	UPDATE @RS_TEMP SET QT_SOL = 0 
		WHERE
		(QT_SOL - QT_EST_MTZ) < = 0 

	UPDATE @RS_TEMP SET QT_SOL = 0 
		WHERE
		QT_MIN = 0

	DELETE FROM @RS_TEMP WHERE QT_SOL = 0
RETURN
END
GO


